cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

############################################################################
#########################	   read in data       ##########################
############################################################################

############ 2nd naive RNAseq
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1

n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24p","n24m","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:11],1,mean),apply(nfpkm2nd[,12:13],1,mean),apply(nfpkm2nd[,14:16],1,mean),apply(nfpkm2nd[,17:19],1,mean),apply(nfpkm2nd[,20:21],1,mean),apply(nfpkm2nd[,22:23],1,mean),apply(nfpkm2nd[,24:25],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)
nData <- log2(nData2ndfpkm+1)
############ 2nd primed RNAseq
pData2ndfpkm <- read.table("../data/paper.primed.fpkm.txt",header=T,row.names=1)
pData <- log2(pData2ndfpkm+1)

common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","iPSC-T")

## 2nd naive DNA methylation ratio on promoter
methyratio_promoter <- read.table("../data/2nd_average_methratio_on_promoter.txt",header=T,row.names=1)
hiFT <- methyratio_promoter[,"hiFT"]
he6 <- methyratio_promoter[,"he6"]
n12 <- apply(methyratio_promoter[,c("n12","n12_r2")],1,mean,na.rm=TRUE)
n20 <- methyratio_promoter[,"n20"]
n24 <- methyratio_promoter[,"n24"]
niPS <- methyratio_promoter[,"niPS"]
methyratio_promoter <- cbind(hiFT,he6,n12,n20,n24,niPS)
methy_n_path <- c("hiFT","he6","n12","n20","n24","niPS")
methy_n_label <- c("hiF-T","6d","12d","20d","24d+dox","niPSC-T")
## 2nd naive HM on promoter
# hm_promoter <- read.table("../data/HM_gene_promoter_uniq_all.txt",header=T,row.names=1)
hm_promoter <- read.table("../data/HM_gene_promoter_uniq_all_0327.txt",header=T,row.names=1)
hm_n_path <- c("hiF","he6","n24","niPS")
hm_p_path <- c("hiF","he6","p24","piPS")
n_K4me2_path <- c("hiF_K4me2","he6_K4me2","n24_K4me2","niPS_K4me2")
p_K4me2_path <- c("hiF_K4me2","he6_K4me2","p24_K4me2","piPS_K4me2")
n_K4me3_path <- c("hiF_K4me3","he6_K4me3","n24_K4me3","niPS_K4me3")
p_K4me3_path <- c("hiF_K4me3","he6_K4me3","p24_K4me3","piPS_K4me3")
n_K27me3_path <- c("hiF_K27me3","he6_K27me3","n24_K27me3","niPS_K27me3")
p_K27me3_path <- c("hiF_K27me3","he6_K27me3","p24_K27me3","piPS_K27me3")
hm_n_label <- c("hiF-T","6d","24d+dox","niPSC-T")

############ HCP genes
HCP_tmp <- intersect(unique(as.vector(read.table("../data/hg19.HCP.HS.genes")[,1])),row.names(nData))
ICP_tmp <- intersect(unique(as.vector(read.table("../data/hg19.ICP.HS.genes")[,1])),row.names(nData))
LCP_tmp <- intersect(unique(as.vector(read.table("../data/hg19.LCP.HS.genes")[,1])),row.names(nData))
HCP <- setdiff(setdiff(HCP_tmp,ICP_tmp),LCP_tmp)
ICP <- setdiff(setdiff(ICP_tmp,HCP_tmp),LCP_tmp)
LCP <- setdiff(setdiff(LCP_tmp,ICP_tmp),HCP_tmp)

############################################################################
#########################	         plot         ##########################
############################################################################

ClusterGeneHeatmap <- function(HCP,ICP,LCP,name){
	pdf(paste(name,"_diffCGgene_heatmap.pdf",sep=""),width=10,height=10)
	par(mar=c(3,2,3,2))
	layout(matrix(c(rep(1,11),2,rep(1,11),2,rep(3,11),4,rep(3,11),4,rep(5,11),6,rep(7,11),8,rep(9,11),10),nrow=12,ncol=7)) # without primedexpression/K27/K9
	# layout(matrix(c(rep(1,11),2,rep(3,11),4,rep(5,11),6,rep(7,11),8,rep(9,11),10),nrow=12,ncol=5))# K27
	# layout(matrix(c(rep(1,11),2,rep(3,11),4,rep(5,11),6,rep(7,11),8,rep(9,11),10,rep(11,11),12,rep(13,11),14),nrow=12,ncol=7))# K27 /K9 
	plot_data_n <- nData[c(HCP,ICP,LCP),n_time_point]
	# plot_data_p <- pData[c(HCP,ICP,LCP),c("hiFT","d2","d5","d8","d10","d14","d20","d24p","d24m","hiPST")]
	# all_exp <- c(as.matrix(plot_data_n),as.matrix(plot_data_n)) # using same scale bar
	all_exp <- as.matrix(plot_data_n) # using same scale bar
	zmax <- quantile(all_exp,0.99)
	zmin <- quantile(all_exp,0.01)
	# naive RNA seq
	ColorRamp <- colorRampPalette(c("lightblue","white","red"), bias=1)(1000)   #color list
	plotMatrix <- plot_data_n
	# all_exp <- c(as.matrix(plotMatrix))
	# zmax <- quantile(all_exp,0.99)
	# zmin <- quantile(all_exp,0.01)
	plotMatrix[plotMatrix<zmin] <- zmin
	plotMatrix[plotMatrix>zmax] <- zmax
	ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
	image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="mRNA",ylab="")
	axis(side=1,1:ncol(plotMatrix),labels=n_label,las=2)
	abline(h=length(HCP)+0.5,lwd=2)
	abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	abline(h=length(HCP)+0.5,lwd=2)
	abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
	axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
	# #primed RNA seq
	# ColorRamp <- colorRampPalette(c("lightblue","white","red"), bias=1)(1000)   #color list
	# plotMatrix <- plot_data_p
	# # all_exp <- c(as.matrix(plotMatrix))
	# # zmax <- quantile(all_exp,0.99)
	# # zmin <- quantile(all_exp,0.01)
	# plotMatrix[plotMatrix<zmin] <- zmin
	# plotMatrix[plotMatrix>zmax] <- zmax
	# ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
	# image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="primed",ylab="")
	# axis(side=1,1:ncol(plotMatrix),labels=n_label,las=2)
	# abline(h=length(HCP)+0.5,lwd=2)
	# abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	# image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
	# axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
	
	# naive DNA methylation
	plot_data <- methyratio_promoter[c(HCP,ICP,LCP),methy_n_path]
	ColorRamp <- colorRampPalette(c("lightblue","white","red"), bias=1)(1000)   #color list
	plotMatrix <- plot_data
	all_exp <- na.omit(c(as.matrix(plotMatrix)))
	zmax <- quantile(all_exp,0.99)
	zmin <- quantile(all_exp,0.01)
	plotMatrix[plotMatrix<zmin] <- zmin
	plotMatrix[plotMatrix>zmax] <- zmax
	ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
	image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="DNA methylation",ylab="")
	axis(side=1,1:ncol(plotMatrix),labels=methy_n_path,las=2)
	abline(h=length(HCP)+0.5,lwd=2)
	abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
	axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
	# naive K4me2
	plot_data <- hm_promoter[c(HCP,ICP,LCP),n_K4me2_path]
	ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(1000)   #color list
	plotMatrix <- plot_data
	all_exp <- na.omit(c(as.matrix(plotMatrix)))
	zmax <- quantile(all_exp,0.99)
	zmin <- quantile(all_exp,0.01)
	plotMatrix[plotMatrix<zmin] <- zmin
	plotMatrix[plotMatrix>zmax] <- zmax
	ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
	image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="H3K4me2",ylab="")
	axis(side=1,1:ncol(plotMatrix),labels=hm_n_path,las=2)
	abline(h=length(HCP)+0.5,lwd=2)
	abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
	axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
	# naive K4me3
	plot_data <- hm_promoter[c(HCP,ICP,LCP),n_K4me3_path]
	ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(1000)   #color list
	plotMatrix <- plot_data
	all_exp <- na.omit(c(as.matrix(plotMatrix)))
	zmax <- quantile(all_exp,0.99)
	zmin <- quantile(all_exp,0.01)
	plotMatrix[plotMatrix<zmin] <- zmin
	plotMatrix[plotMatrix>zmax] <- zmax
	ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
	image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="H3K4me3",ylab="")
	axis(side=1,1:ncol(plotMatrix),labels=hm_n_path,las=2)
	abline(h=length(HCP)+0.5,lwd=2)
	abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
	axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
	# naive K27me3
	plot_data <- hm_promoter[c(HCP,ICP,LCP),n_K27me3_path]
	ColorRamp <- colorRampPalette(c("lightblue","red"), bias=1)(1000)   #color list
	plotMatrix <- plot_data
	all_exp <- na.omit(c(as.matrix(plotMatrix)))
	zmax <- quantile(all_exp,0.99)
	zmin <- quantile(all_exp,0.01)
	plotMatrix[plotMatrix<zmin] <- zmin
	plotMatrix[plotMatrix>zmax] <- zmax
	ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
	image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="H3K27me3",ylab="")
	axis(side=1,1:ncol(plotMatrix),labels=hm_n_path,las=2)
	abline(h=length(HCP)+0.5,lwd=2)
	abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
	axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
	# # naive K9me3
	# plot_data <- hm_promoter[c(HCP,ICP,LCP),n_K9me3_path]
	# ColorRamp <- colorRampPalette(c("lightblue","white","red"), bias=1)(1000)   #color list
	# plotMatrix <- plot_data
	# all_exp <- na.omit(c(as.matrix(plotMatrix)))
	# zmax <- quantile(all_exp,0.99)
	# zmin <- quantile(all_exp,0.01)
	# plotMatrix[plotMatrix<zmin] <- zmin
	# plotMatrix[plotMatrix>zmax] <- zmax
	# ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
	# image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="naive K9me3",ylab="")
	# axis(side=1,1:ncol(plotMatrix),labels=hm_n_path,las=2)
	# abline(h=length(HCP)+0.5,lwd=2)
	# abline(h=length(HCP)+length(ICP)+0.5,lwd=2)
	# image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
	# axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
	
	dev.off()
}

n_deg <- read.table("../Fig2/Gfold/cutoff.0.58/naive.2nd.deg")[,1]
n_deg <- intersect(n_deg,rownames(nData))
nData <- nData[n_deg,]
library(amap)
k <- 14
set.seed(4)

km <- kmeans(nData,k)
nData <- log2(nData2ndfpkm[,]+1)
n_deg <- intersect(n_deg,rownames(nData))
nData <- nData[n_deg,]

km <- Kmeans(nData,k,method = "correlation")

selected_cluster <- c(10,11,4,5,8,6,2)

up <- c(names(which(km$cluster==4)),names(which(km$cluster==5)))
tmp_HCP <- intersect(HCP,up)
tmp_ICP <- intersect(ICP,up)
tmp_LCP <- intersect(LCP,up)
write.table(tmp_HCP,file="up.HCP.genes.txt",quote=F,col.names=F,row.names=F)
write.table(tmp_ICP,file="up.ICP.genes.txt",quote=F,col.names=F,row.names=F)
write.table(tmp_LCP,file="up.LCP.genes.txt",quote=F,col.names=F,row.names=F)
ClusterGeneHeatmap(tmp_HCP,tmp_ICP,tmp_LCP,"up")

# down <- c(names(which(km$cluster==1)),names(which(km$cluster==9)))
# tmp_HCP <- intersect(HCP,down)
# tmp_ICP <- intersect(ICP,down)
# tmp_LCP <- intersect(LCP,down)
# write.table(tmp_HCP,file="down.HCP.genes.txt",quote=F,col.names=F,row.names=F)
# write.table(tmp_ICP,file="down.ICP.genes.txt",quote=F,col.names=F,row.names=F)
# write.table(tmp_LCP,file="down.LCP.genes.txt",quote=F,col.names=F,row.names=F)
# ClusterGeneHeatmap(tmp_HCP,tmp_ICP,tmp_LCP,"down")
